<?php
function site_url() {
    return "https://" . $_SERVER['HTTP_HOST'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMM Panel Setup Documentation</title>
    <style>
    /* Modern Theme Styles */
:root {
    --primary-color: #6c5ce7; /* Purple */
    --secondary-color: #00b894; /* Green */
    --background-light: #f8f9fa;
    --background-dark: #2d3436;
    --text-light: #2d3436;
    --text-dark: #f8f9fa;
    --card-bg: #ffffff;
    --card-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    --border-radius: 12px;
    --transition-speed: 0.3s;
}

[data-theme="dark"] {
    --primary-color: #a29bfe; /* Light Purple */
    --secondary-color: #55efc4; /* Light Green */
    --background-light: #2d3436;
    --background-dark: #1e1e1e;
    --text-light: #f8f9fa;
    --text-dark: #f8f9fa;
    --card-bg: #34495e;
    --card-shadow: 0 4px 6px rgba(0, 0, 0, 0.3);
}

/* General Styles */
body {
    font-family: 'Inter', sans-serif;
    line-height: 1.6;
    margin: 0;
    padding: 20px;
    background-color: var(--background-light);
    color: var(--text-light);
    transition: background-color var(--transition-speed) ease, color var(--transition-speed) ease;
}

.container {
    max-width: 800px;
    margin: 0 auto;
    padding: 20px;
    background-color: var(--card-bg);
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: background-color var(--transition-speed) ease, box-shadow var(--transition-speed) ease;
}

h1 {
    font-size: 32px;
    color: var(--primary-color);
    margin-bottom: 20px;
    border-bottom: 2px solid var(--primary-color);
    padding-bottom: 10px;
    font-weight: 700;
}

h2 {
    font-size: 26px;
    color: var(--primary-color);
    margin-top: 30px;
    margin-bottom: 15px;
    font-weight: 600;
}

h3 {
    font-size: 22px;
    color: var(--primary-color);
    margin-top: 20px;
    margin-bottom: 10px;
    font-weight: 500;
}

p {
    font-size: 16px;
    margin-bottom: 15px;
    color: var(--text-light);
}

ul, ol {
    margin-bottom: 15px;
    padding-left: 20px;
}

li {
    margin-bottom: 8px;
    color: var(--text-light);
}

code {
    background-color: var(--background-dark);
    padding: 2px 6px;
    border-radius: 4px;
    font-family: "Fira Code", monospace;
    color: var(--secondary-color);
}

a {
    color: var(--primary-color);
    text-decoration: none;
    transition: color var(--transition-speed) ease;
}

a:hover {
    color: var(--secondary-color);
    text-decoration: underline;
}

/* Cron Job Styles */
.cron-job {
    display: flex;
    align-items: center;
    margin-bottom: 10px;
    padding: 10px;
    background-color: var(--background-dark);
    border-radius: 8px;
    font-family: "Fira Code", monospace;
    font-size: 14px;
    color: var(--text-dark);
    transition: background-color var(--transition-speed) ease, color var(--transition-speed) ease;
}

.cron-job span {
    flex-grow: 1;
    color: var(--text-dark);
}

.copy-btn {
    background-color: var(--primary-color);
    color: #fff;
    border: none;
    padding: 8px 16px;
    border-radius: 6px;
    cursor: pointer;
    font-size: 14px;
    margin-left: 10px;
    transition: background-color var(--transition-speed) ease, transform 0.2s ease;
}

.copy-btn:hover {
    background-color: var(--secondary-color);
    transform: translateY(-2px);
}

/* Dark Mode Toggle */
.theme-toggle {
    position: fixed;
    top: 20px;
    right: 20px;
    background-color: var(--primary-color);
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: var(--border-radius);
    cursor: pointer;
    font-size: 14px;
    transition: background-color var(--transition-speed) ease;
}

.theme-toggle:hover {
    background-color: var(--secondary-color);
}

/* Responsive Design */
@media (max-width: 600px) {
    .container {
        padding: 15px;
    }

    h1 {
        font-size: 28px;
    }

    h2 {
        font-size: 22px;
    }

    h3 {
        font-size: 18px;
    }

    .cron-job {
        font-size: 12px;
    }

    .copy-btn {
        padding: 6px 12px;
        font-size: 12px;
    }
}

/* Additional Enhancements */
/* Add a subtle animation to headings */
h1, h2, h3 {
    animation: fadeIn 0.5s ease-in-out;
}

@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Add a hover effect to cards */
.container:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
    transition: transform var(--transition-speed) ease, box-shadow var(--transition-speed) ease;
}

/* Style the scrollbar */
body::-webkit-scrollbar {
    width: 10px;
}

body::-webkit-scrollbar-track {
    background: var(--background-light);
}

body::-webkit-scrollbar-thumb {
    background: var(--primary-color);
    border-radius: 5px;
}

body::-webkit-scrollbar-thumb:hover {
    background: var(--secondary-color);
}
    </style>
    <script>
        function copyToClipboard(id, button) {
            let copyText = document.getElementById(id).innerText;
            navigator.clipboard.writeText(copyText).then(() => {
                button.innerText = "Copied";
                setTimeout(() => {
                    button.innerText = "Copy";
                }, 2000);
            }).catch(err => {
                console.error("Failed to copy: ", err);
            });
        }
        
        
    </script>
</head>
<body>
    <script>
    const toggleButton = document.createElement('button');
    toggleButton.className = 'theme-toggle';
    toggleButton.innerText = 'Change Theme';
    document.body.appendChild(toggleButton);

    toggleButton.addEventListener('click', () => {
        const currentTheme = document.documentElement.getAttribute('data-theme');
        const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
        document.documentElement.setAttribute('data-theme', newTheme);
    });
</script>

    <div class="container">
        <h1 style="text-align: center;">SMM Panel Setup</h1>
<marquee style="font-size: 18px; font-weight: bold; color: #ffffff; background: #007bff; padding: 10px; border-radius: 5px;">
    This website is developed by 
    <a href="https://instagram.com/sundaretion" target="_blank" style="color: #ffdd57; text-decoration: none; font-weight: bold;">
        Sundaresan b.e
    </a>.
</marquee>
        <h1>Requirements</h1>
<p>	PHP 7.4 (ea-php74)</p>

        <hr>
        <h2>1. Configuration File: <code>app/config.php</code></h2>
        <p>Change website link .htacces file</p>
          <hr>
        <h2>2. Mail Configuration</h2>
        <p>The mail configuration is managed in the following files:</p>
        <ul>
            <li><code>app/classes/mail.php</code> - Handles the mailer class setup.</li>
            <li><code>admin/controller/ajax_data.php</code> - Processes mail-related AJAX requests.</li>
            <li><code>Admin Panel</code> - Provides UI settings for mail configuration.</li>
        </ul>

        <h3>Mail Configuration Details</h3>
        <p><strong>Important:</strong> Do not change the port number and TLS settings, as they are default.</p>  <hr>
          <h2>If mail function is not working solution</h2>
            <h3>Step 1: Enable SPF & DKIM in cPanel</h3>
    <ul>
      <li>Log in to cPanel.</li>
      <li>Go to "Email Deliverability" (under the "Email" section).</li>
      <li>Find your domain and click "Manage".</li>
      <li>If SPF or DKIM is not enabled, click "Install the Suggested Record" for both.</li>
      <li>This automatically sets up SPF and DKIM records in your DNS.</li>
    </ul>

    <h3>Step 2: Manually Verify and Update DNS Records</h3>
    <h3>SPF Record</h3>
    <ul>
      <li>Go to cPanel > Zone Editor.</li>
      <li>Click "Manage" for your domain.</li>
      <li>Look for an existing TXT record starting with <code>v=spf1</code>. If it exists, edit it; otherwise, click "Add Record".</li>
      <li>Set the Type to TXT, enter the Name as your domain (e.g., yourdomain.com), and set the Value as:</li>
    </ul>
    <code>v=spf1 include:_spf.google.com ~all</code>
    <p>If you use a different mail server, check with your email provider for the correct SPF entry.</p>

    <h3>DKIM Record</h3>
    <ul>
      <li>In Email Deliverability, find the DKIM Key under "DKIM".</li>
      <li>Copy the long TXT record value.</li>
      <li>Go to Zone Editor, click "Add Record", and set:</li>
    </ul>
    <code>Type: TXT<br>Name: default._domainkey.yourdomain.com<br>Value: [Paste the DKIM key from Email Deliverability]</code>

    <h3>Step 3: Test and Verify</h3>
    <ul>
      <li>Wait for DNS propagation (this can take a few hours).</li>
      <li>Use MXToolBox to check if your SPF and DKIM records are correctly set.</li>
      <li>Try sending an email again.</li>
    </ul>

    <h3>Step 4: Set Up DMARC (Optional, but Recommended)</h3>
    <p>DMARC helps prevent spoofing.</p>
    <ul>
      <li>In Zone Editor, add a new TXT record:</li>
    </ul>
    <code>Name: _dmarc.yourdomain.com<br>Value: v=DMARC1; p=none; rua=mailto:you@yourdomain.com</code>
    <p>Change <code>you@yourdomain.com</code> to your actual email.</p>

    <h3>Final Step: Test Sending Again</h3>
  <hr>
        <h2>3. Setup Cron Jobs</h2>
        <p>To ensure the system runs scheduled tasks efficiently, set up cron jobs.</p>
        <h3>Example Cron Jobs:</h3>

        <div class="cron-job">
            <span id="autolike">wget --spider -O - <?= site_url(); ?>/cronjobs/autolike.php</span>
            <button class="copy-btn" onclick="copyToClipboard('autolike', this)">Copy</button>
        </div>
        <div class="cron-job">
            <span id="orders">wget --spider -O - <?= site_url(); ?>/cronjobs/orders.php</span>
            <button class="copy-btn" onclick="copyToClipboard('orders', this)">Copy</button>
        </div>
        <div class="cron-job">
            <span id="autoreply">wget --spider -O - <?= site_url(); ?>/cronjobs/autoreply.php</span>
            <button class="copy-btn" onclick="copyToClipboard('autoreply', this)">Copy</button>
        </div>
        <div class="cron-job">
            <span id="dripfeed">wget --spider -O - <?= site_url(); ?>/cronjobs/dripfeed.php</span>
            <button class="copy-btn" onclick="copyToClipboard('dripfeed', this)">Copy</button>
        </div>
        <div class="cron-job">
            <span id="payments">wget --spider -O - <?= site_url(); ?>/cronjobs/payments.php</span>
            <button class="copy-btn" onclick="copyToClipboard('payments', this)">Copy</button>
        </div>
        <div class="cron-job">
            <span id="refill">wget --spider -O - <?= site_url(); ?>/cronjobs/refill.php</span>
            <button class="copy-btn" onclick="copyToClipboard('refill', this)">Copy</button>
        </div>
        <div class="cron-job">
            <span id="seller-sync">wget --spider -O - <?= site_url(); ?>/cronjobs/seller-sync.php</span>
            <button class="copy-btn" onclick="copyToClipboard('seller-sync', this)">Copy</button>
        </div>
        <div class="cron-job">
            <span id="average">wget --spider -O - <?= site_url(); ?>/cronjobs/average.php</span>
            <button class="copy-btn" onclick="copyToClipboard('average', this)">Copy</button>
        </div>
        
        <p>After setting up the cron jobs, check your email to confirm they are running correctly. Replace <code>yourdomain.com</code> with your actual domain name.</p>
  <hr>
        <h2>4. Activate Two-Factor Authentication</h2>
        <p>Enable two-factor authentication (2FA) via the Admin Panel to enhance security.</p>
        <p><strong>Note:</strong> If needed, you can deactivate 2FA via the database in <code>phpMyAdmin</code>. Navigate to the <code>admin</code> table, find the column <code>two_factor</code>, and change its value from <code>1</code> to <code>0</code>.</p>
  <hr>
        <h2>5. Connect to Google Console Auth</h2>
        <p>To integrate Google authentication, connect your system to <a href="https://console.cloud.google.com/">Google Console</a>. Set up OAuth 2.0 credentials and configure them within your Admin Panel.</p>
        <p><strong>Authorize JavaScript Origins:</strong></p>
        <div class="cron-job">
            <span id="javascript-origin"> <?= site_url(); ?>/</span>
            <button class="copy-btn" onclick="copyToClipboard('javascript-origin', this)">Copy</button>
        </div>
        <p><strong>Authorized Redirect URIs:</strong></p>
        <div class="cron-job">
            <span id="redirect-uri1"> <?= site_url(); ?>/</span>
            <button class="copy-btn" onclick="copyToClipboard('redirect-uri1', this)">Copy</button>
        </div>
        <div class="cron-job">
            <span id="redirect-uri2"> <?= site_url(); ?>/auth.php</span>
            <button class="copy-btn" onclick="copyToClipboard('redirect-uri2', this)">Copy</button>
        </div>
        
          <hr>
        <h2>6. Connect Telegram Bot Token</h2>
        <p>To set up Telegram bot notifications, follow these steps:</p>
        <ol>
            <li>Go to Telegram and search for <code>BotFather</code>.</li>
            <li>Start a chat and type <code>/newbot</code>.</li>
            <li>Follow the instructions and get your **Bot Token**.</li>
            <li>Copy the token and update your bot details in the **Admin Panel**.</li>
        </ol>

        <h3>Find Your Telegram Chat ID</h3>
        <p>To find your chat ID, message the bot: <a href="https://t.me/whatchatidbot" target="_blank">t.me/whatchatidbot</a> and copy your chat ID.</p>

        <h3>Admin Panel Settings</h3>
        <p>Go to **Admin Panel → Settings** and enter your **Bot Token** and **Chat ID**:</p>
        <ul>
            <li><strong>Bot Token:</strong> Paste your bot token</li>
            <li><strong>Chat ID:</strong> Paste your chat ID</li>
        </ul>  <hr>
        <h2>7. Verify API Provider Details</h2>
<p>Ensure that your API provider details are correctly configured in your system.</p>
<ul>
    <li>Go to <strong>Admin Panel →  Settings → provider</strong>.</li>
    <li>Check if the API provider name, key, and base URL are correctly entered.</li>
    <li>Ensure that the selected currency is supported by the API provider.</li>  <hr>
  <h2>8. Add Payment Gateway</h2>
<p>To integrate a new payment gateway, modify the following files:</p>

<h3>1. Update Database</h3>
<p>Modify the SQL structure to include the new gateway in <code>payment_gateways</code> and  tables.</p>

<h3>2. Admin files</h3>
<p>Edit the files in <code>admin/controllers/settings/paymentgateway/</code> Full php files.</p>

<h3>3. app files</h3>
<ul>
    <li><code>app/controller/addfunds.php</code> - Add logic for the new gateway.</li>
    <li><code>app/controller/payments.php</code> - Handle payment verification and responses.</li>
    <li><code>app/controller/payment/pg.php</code> - Communicate with the gateway API.</li>
    <li><code>app/controller/addfunds/getform.php</code> - Modify form to support the new gateway.</li>
    <li><code>app/controller/addfunds/initiator/pg.php</code> - Process payment initiation.</li>
</ul>

<p>Once these changes are made, test the gateway to ensure smooth transactions.</p>
<hr>
 <h2>9. To change site SEO of Pages </h2>
        <p>please change in phpmyadmin sql in pages table.</p>
        

<marquee style="font-size: 18px; font-weight: bold; color: #ffffff; background: #007bff; padding: 10px; border-radius: 5px;">
    This website is developed by 
    <a href="https://instagram.com/sundaretion" target="_blank" style="color: #ffdd57; text-decoration: none; font-weight: bold;">
        Sundaresan b.e
    </a>.
</marquee>
    </div>
    
</body>
</html>