<?php
if (!defined('BASEPATH')) {
    die('Direct access to the script is not allowed');
}

if ($_SESSION["msmbilisim_userlogin"] != 1 || $user["client_type"] == 1) {
    header("Location:" . site_url('logout'));
}
if ($settings["email_confirmation"] == 1 && $user["email_type"] == 1) {
    header("Location:" . site_url('confirm_email'));
}

define("PAYMENT", TRUE);


$callbackSlug = route(1);
$response = [];
if (empty($callbackSlug)) {
    errorExit("Invalid payment method callback.");
}

$paymentMethod = $conn->prepare("SELECT * FROM paymentmethods WHERE methodCallback=:callbackSlug AND methodStatus=:status");
$paymentMethod->execute([
    "callbackSlug" => $callbackSlug,
    "status" => 1
]);
if ($paymentMethod->rowCount()) {
    $paymentMethod = $paymentMethod->fetch(PDO::FETCH_ASSOC);
    $methodId = $paymentMethod["methodId"];
    $methodMin = number_format($paymentMethod["methodMin"], 2, '.', '');
    $methodMax = number_format($paymentMethod["methodMax"], 2, '.', '');
    $methodCurrency = $paymentMethod["methodCurrency"];
    $methodCurrencySymbol = $currencies_array[$methodCurrency][0]["currency_symbol"] ?: $methodCurrency;
    $methodExtras = json_decode($paymentMethod["methodExtras"], 1);
    $paymentFee = $paymentMethod["methodFee"];
    $paymentBonus = $paymentMethod["methodBonusPercentage"];
    $paymentBonusStartAmount = $paymentMethod["methodBonusStartAmount"];
    
    // 
    // Send email notification
$emailContent = "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>Fund Addition Successful</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
      text-align: center;
    }
    .email-container {
      width: 100%;
      max-width: 600px;
      margin: 20px auto;
      background-color: #ffffff;
      padding: 30px;
      box-sizing: border-box;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
      border-radius: 8px;
    }
    .header-container {
      background-color: #007bff;
      padding: 20px;
      margin: -30px -30px 20px -30px;
      text-align: center;
      border-top-left-radius: 8px;
      border-top-right-radius: 8px;
    }
    .header {
      color: white;
      font-size: 22px;
      font-weight: bold;
    }
    p {
      font-size: 16px;
      line-height: 1.6;
      padding: 5px 10px;
      text-align: center;
    }
    .button {
      background-color: #007bff;
      color: white;
      text-decoration: none;
      padding: 12px 25px;
      border-radius: 5px;
      display: inline-block;
      font-size: 16px;
      text-align: center;
      margin-top: 20px;
      font-weight: bold;
    }
    .button:hover {
      background-color: #0056b3;
    }
    @media only screen and (max-width: 600px) {
      .email-container {
        padding: 20px;
      }
      .header-container {
        padding: 15px;
      }
      .header {
        font-size: 20px;
      }
      .button {
        width: 100% !important;
        padding: 15px !important;
        font-size: 18px !important;
        display: block;
      }
    }
  </style>
</head>
<body>
  <div class='email-container'>
    <div class='header-container'>
      <div class='header'>Funds Added Successfully</div>
    </div>
    
    <p><strong>Hello {$user['username']},</strong></p>
    <p>Your funds <strong>Added</strong>  <strong></strong> has been successfully processed.</p>

    <p>Thank you for using <strong>{$settings['site_name']}</strong>.</p>

    <br>
    <p><strong>Best regards,</strong><br>
    <span style='color: #007bff; font-weight: bold;'>{$settings['site_name']} Team</span></p>
  </div>
</body>
</html>";


$site_name = $settings["site_name"];
$to = $user["email"];
$from = $settings["smtp_user"];
$fromName = $settings["site_seo"];
$subject = "Funds Added Successfully";

$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= 'From: '.$fromName.'<'.$from.'>' . "\r\n";
$headers .= 'Cc: '.$from . "\r\n";
$headers .= 'Bcc: '.$from . "\r\n";

mail($to, $subject, $emailContent, $headers);

    if ($callbackSlug == "payTMCheckout") {
        require("payment/payTMCheckout.php");
        exit;
    }

    if ($callbackSlug == "payTMMerchant") {
        require("payment/payTMMerchant.php");
        exit;
    }

    if ($callbackSlug == "perfectMoney") {
        require("payment/perfectMoney.php");
        exit;
    }

    if ($callbackSlug == "coinbaseCommerce") {
        require("payment/coinbaseCommerce.php");
        exit;
    }

    if ($callbackSlug == "kashier") {
        require("payment/kashier.php");
        exit;
    }

    if ($callbackSlug == "razorPay") {
        require("payment/razorPay.php");
        exit;
    }

    if ($callbackSlug == "phonepe") {
        require("payment/phonepe.php");
        exit;
    }

    if ($callbackSlug == "easypaisa") {
        require("payment/easypaisa.php");
        exit;
    }

    if ($callbackSlug == "jazzcash") {
        require("payment/jazzcash.php");
        exit;
    }

    if ($callbackSlug == "instamojo") {
        require("payment/instamojo.php");
        exit;
    }

    if ($callbackSlug == "alipay") {
        require("payment/alipay.php");
        exit;
    }

    if ($callbackSlug == "payU") {
        require("payment/payU.php");
        exit;
    }

    if ($callbackSlug == "upiapi") {
        require("payment/upiapi.php");
        exit;
    }

    if ($callbackSlug == "opay") {
        require("payment/opay.php");
        exit;
    }

    if ($callbackSlug == "flutterwave") {
        require("payment/flutterwave.php");
        exit;
    }

    if ($callbackSlug == "stripe") {
        require("payment/stripe.php");
        exit;
    }

    if ($callbackSlug == "payeer") {
        require("payment/payeer.php");
        exit;
    }
    if ($callbackSlug == "bharatpe") {
        require("payment/bharatpe.php");
        exit;
    }
    if ($callbackSlug == "upigateway") {
        require("payment/upigateway.php");
        exit;
}
if ($callbackSlug == "pg1") {
        require("payment/pg1.php");
        exit;
    }
    if ($callbackSlug == "pg2") {
        require("payment/pg2.php");
        exit;
    }
} else {
    errorExit("Invalid payment method callback.");
}