
session_start();
<?php include 'header.php'; ?>

// Fetch all transactions
$payments = $conn->prepare("SELECT p.*, c.username AS sender_username 
                            FROM payments p 
                            LEFT JOIN clients c ON p.client_id = c.client_id 
                            ORDER BY p.payment_create_date DESC");
$payments->execute();
$payments = $payments->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Transfer Details</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <h2>Funds Transfer Details</h2>
    <table border="1">
        <tr>
            <th>Transaction ID</th>
            <th>Sender</th>
            <th>Amount</th>
            <th>Fee</th>
            <th>Final Amount</th>
            <th>Note</th>
            <th>Date</th>
            <th>Status</th>
        </tr>
        <?php foreach ($payments as $payment) : ?>
            <tr>
                <td><?= htmlspecialchars($payment['id']) ?></td>
                <td><?= htmlspecialchars($payment['sender_username']) ?></td>
                <td>$<?= number_format(abs($payment['payment_amount']), 2) ?></td>
                <td>$<?= number_format(abs($payment['payment_amount'] * $fees / 100), 2) ?></td>
                <td>$<?= number_format(abs($payment['payment_amount']) - ($payment['payment_amount'] * $fees / 100), 2) ?></td>
                <td><?= htmlspecialchars($payment['payment_note']) ?></td>
                <td><?= htmlspecialchars($payment['payment_create_date']) ?></td>
                <td><?= $payment['payment_status'] == 3 ? "Completed" : "Pending" ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>

<?php include 'footer.php'; ?>
