<style>


  /* General Styling */
  body {
    font-family: 'Inter', sans-serif;
    background-color: #f7f9fc;
    color: #333333;
  }

  /* Integration Block Styling */
  .settings-emails__block {
    border-radius: 8px;
    background-color: #ffffff;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    margin-bottom: 20px;
  }

  .settings-emails__block-title {
    font-weight: 600;
    font-size: 1.2em;
    color: #333333;
    padding: 16px;
    border-bottom: 1px solid #e9ecef;
  }

  .settings-emails__block-body {
    padding: 20px;
  }

  /* Table Styling */
  table {
    width: 100%;
    border-collapse: collapse;
  }

  th, td {
    padding: 12px;
    text-align: left;
  }

  .settings-emails__row {
    border-bottom: 1px solid #e9ecef;
  }

  .settings-emails__row:hover {
    background-color: #f9fbfd;
  }

  /* Image Styling */
  .settings-emails__row-img img {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    margin-right: 10px;
  }

  /* Row Styling */
  .settings-emails__row-name {
    font-weight: 600;
    color: #333333;
  }

  .settings-emails__row-description {
    color: #777777;
    font-size: 0.9em;
  }

  .settings-emails__row-disable {
    opacity: 0.6;
  }

  /* Button Styling */
  .btn-default {
    background-color: #f0f0f0;
    color: #333333;
    border: 1px solid #ccc;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 0.85em;
  }

  .btn-default:hover {
    background-color: #e9ecef;
  }

  .btn-primary {
    background-color: #007bff;
    color: #ffffff;
    border-radius: 6px;
    padding: 6px 12px;
  }
</style>

<div class="col-md-8">

<?php if($active){ ?>
<!-- Active başlangıç -->
   <div class="settings-emails__block">
      <div class="settings-emails__block-title">
         Active 
      </div>
      <div class="settings-emails__block-body">
         <table>
            <thead>
               <tr>
                  <th></th>
                  <th class="settings-emails__th-name"></th>
                  <th class="settings-emails__th-actions"></th>
               </tr>
            </thead>
            <tbody>
            <!-- foreach başlangıç -->
              <?php foreach( $active as $int ){ ?>
               <tr class="settings-emails__row settings-emails__row">
                  <td class="settings-emails__row-img">
                     <img src="<?=$int['icon_url']?>" alt="<?=$int['name']?>">
                  </td>
                  <td>
                     <div class="settings-emails__row-name">
                       <?=$int['name']?> 
                     </div>
                     <div class="settings-emails__row-description">
                       <?=$int['description']?> 
                     </div>
                  </td>
                  <td class="settings-emails__td-actions">
                  <?php if($int["id"] == 13){ ?>
                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#modalDiv" data-action="edit_google">Edit</button>
                 <?php }elseif($int["id"] == 14){ ?>
                    <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#modalDiv" data-action="edit_seo">Edit</button>
                 <?php }else{ ?>
                 
                  <button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#modalDiv" data-action="edit_code" data-id="<?=$int['id']?>">Edit</button>
                 <?php } ?>
                  </td>
               </tr>
              <?php } ?>
            <!-- foreach bitiş -->
            </tbody>
         </table>
      </div>
    </div>  
<!-- Active bitiş -->
              <?php } ?>

<?php if($other){ ?>
<!-- Pasif başlangıç -->
<div class="settings-emails__block">
      <div class="settings-emails__block-title">
         Other 
      </div>
      <div class="settings-emails__block-body">
         <table>
            <thead>
               <tr>
                  <th></th>
                  <th class="settings-emails__th-name"></th>
                  <th class="settings-emails__th-actions"></th>
               </tr>
            </thead>
            <tbody>
            <!-- foreach başlangıç -->
              <?php foreach( $other as $int ){ ?>
               <tr class="settings-emails__row settings-emails__row-disable">
                  <td class="settings-emails__row-img">
                     <img src="<?=$int['icon_url']?>" alt="<?=$int['name']?>">
                  </td>
                  <td>
                     <div class="settings-emails__row-name">
                        <?=$int['name']?> 
                     </div>
                     <div class="settings-emails__row-description">
                        <?=$int['description']?>
                     </div>
                  </td>
                  <td class="settings-emails__td-actions">
                     <a class="btn btn-xs btn-default activate-integration" href="/admin/settings/integrations/enabled/<?=$int['id']?>">
                       Activate
                     </a>
                  </td>
               </tr>
              <?php } ?> 
            <!-- foreach bitiş -->
            </tbody>
         </table>
      </div>
    </div>  
<!-- Pasif bitiş -->
<?php } ?>


   </div>