<?php include 'admin_security.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo htmlspecialchars($settings['site_name']); ?> Admin Login</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
    :root {
      --primary-color: #ff0000; /* Neon Red */
      --secondary-color: #6f42c1; /* Purple */
      --bg-dark: #0d0d0d;
      --blue-border: #00aaff;
      --neon-glow: 0 0 15px rgba(0, 170, 255, 0.7);
    }

    /* Full Page Background */
    body {
      font-family: 'Orbitron', sans-serif;
      background: var(--bg-dark);
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      overflow: hidden;
      position: relative;
    }

    /* Glassmorphism Login Box */
    .login-container {
      width: 400px;
      padding: 40px 30px;
      border-radius: 15px;
      background: rgba(255, 255, 255, 0.05);
      border: 1px solid rgba(255, 255, 255, 0.2);
      backdrop-filter: blur(10px);
      box-shadow: 0 0 15px rgba(255, 0, 0, 0.5);
      text-align: center;
      z-index: 1;
    }

    .login-container h2 {
      color: var(--primary-color);
      font-weight: 600;
      text-shadow: 0 0 15px var(--primary-color);
      margin-bottom: 20px;
    }

    /* Input Box with Blue Border */
    .input-group {
      position: relative;
      margin-bottom: 20px;
    }

    .input-group input {
      width: 100%;
      padding: 14px 15px;
      border: 2px solid var(--blue-border);
      border-radius: 8px;
      background: rgba(255, 255, 255, 0.1);
      color: #fff;
      font-size: 16px;
      outline: none;
      transition: all 0.3s ease;
    }

    .input-group input:focus {
      box-shadow: var(--neon-glow);
      background: rgba(255, 255, 255, 0.15);
    }

    .input-group label {
      position: absolute;
      top: 50%;
      left: 15px;
      transform: translateY(-50%);
      color: rgba(255, 255, 255, 0.7);
      transition: 0.3s;
      pointer-events: none;
    }

    .input-group input:focus ~ label,
    .input-group input:not(:placeholder-shown) ~ label {
      top: 5px;
      left: 10px;
      font-size: 12px;
      color: var(--blue-border);
    }

    /* Login Button */
    .login-btn {
      width: 100%;
      background: var(--primary-color);
      border: none;
      padding: 14px;
      font-size: 18px;
      font-weight: 600;
      color: #fff;
      border-radius: 8px;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .login-btn:hover {
      box-shadow: 0 0 15px var(--primary-color);
    }

    /* Order Panel Button */
    .order-btn {
      width: 100%;
      background: linear-gradient(45deg, #007bff, #6f42c1);
      border: none;
      padding: 12px;
      font-size: 16px;
      font-weight: 600;
      color: #fff;
      border-radius: 8px;
      cursor: pointer;
      transition: all 0.3s ease;
      margin-top: 15px;
      box-shadow: 0 0 12px rgba(0, 123, 255, 0.7);
    }

    .order-btn:hover {
      box-shadow: 0 0 18px rgba(111, 66, 193, 1);
    }
      /* Dark Mode Toggle */
    .toggle-container {
      position: absolute;
      top: 10px;
      right: 15px;
      display: flex;
      align-items: center;
      gap: 8px;
      cursor: pointer;
    }
    .toggle-container i {
      font-size: 18px;
      color: var(--primary-color);
    }
    .toggle-switch {
      width: 40px;
      height: 20px;
      background: #666;
      border-radius: 20px;
      position: relative;
      cursor: pointer;
      transition: background 0.3s;
    }
    .toggle-switch::before {
      content: "";
      position: absolute;
      width: 16px;
      height: 16px;
      background: #fff;
      border-radius: 50%;
      top: 50%;
      left: 4px;
      transform: translateY(-50%);
      transition: all 0.3s ease;
    }
    .toggle-switch.active {
      background: #00aaff;
    }
    .toggle-switch.active::before {
      left: 20px;
      background: #fff;
    }

    /* Light Mode Styles */
    body.light-mode {
      background: var(--bg-light);
      color: var(--text-light);
    }
    .light-mode .login-container {
      background: var(--box-light);
      box-shadow: 0 0 20px rgba(0, 0, 0, 0.2);
    }
    .light-mode .input-group input {
      background: rgba(0, 0, 0, 0.1);
      color: var(--text-light);
    }
    .light-mode .login-btn, .light-mode .order-btn {
      text-shadow: none;
    }
  </style>
</head>
<body>
  
  <!-- Dark Mode Toggle -->
  <div class="toggle-container" onclick="toggleDarkMode()">
    <i class="fas fa-moon"></i>
    <div class="toggle-switch"></div>
    <i class="fas fa-sun"></i>
  </div>

  <div class="login-container">
    <h2>Admin Login</h2>
    <form name="login-form" action="#" method="post">
      <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
      
      <div class="input-group">
        <input type="text" name="username" placeholder=" " required>
        <label>Username</label>
      </div>
      <div class="input-group">
        <input type="password" name="password" placeholder=" " required>
        <label>Password</label>
      </div>
      <div class="input-group">
        <input type="number" name="two_factor_code" placeholder=" ">
        <label>2FA Code (If Enabled)</label>
      </div>
      
      <button type="submit" class="login-btn">Login</button>

      <!-- Order Panel Button -->
      <a href="https://wa.me/918328311592" target="_blank">
        <button type="button" class="order-btn">
          <i class="fab fa-whatsapp"></i> Order New Panel
        </button>
      </a>
    </form>
  </div>
      <script>
    // Dark Mode Toggle
    function toggleDarkMode() {
      document.body.classList.toggle("light-mode");
      document.querySelector(".toggle-switch").classList.toggle("active");
      let mode = document.body.classList.contains("light-mode") ? "light" : "dark";
      localStorage.setItem("theme", mode);
    }

    // Apply saved theme
    window.onload = function() {
      if (localStorage.getItem("theme") === "light") {
        document.body.classList.add("light-mode");
        document.querySelector(".toggle-switch").classList.add("active");
      }
    }
  </script>
     

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>