<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
     <title><?php echo htmlspecialchars($settings['site_name']); ?> Two-Factor Authentication</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css">
    <style>
    /* Import Google Fonts */
@import url("//fonts.googleapis.com/css2?family=Inter:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap");

/* Auth container */
.auth-container{
 font-family:'Inter', sans-serif;
}


        @import url("//fonts.googleapis.com/css2?family=Inter:wght@400;500;600;display=swap");

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
        }

        body {
            background-color: #f8f9fa; /* Light theme background */
            color: #333333; /* Darker text */
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .auth-container {
            background-color: #ffffff;
            border-radius: 12px;
            padding: 40px;
            max-width: 450px;
            width: 100%;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .auth-header h5, .auth-header h6 {
            margin-bottom: 10px;
        }

        .auth-header h5 {
            font-weight: 600;
        }

        .qr-code {
            height: 250px;
            width: 250px;
            margin: 20px auto;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .code {
            font-weight: 600;
            color: #28a745;
            font-size: 1.1rem;
        }

        .copy-icon {
            color: #007bff;
            cursor: pointer;
            font-size: 1.1rem;
            margin-left: 10px;
        }

        .input-group .form-label {
            font-weight: 500;
            color: #555;
            text-align: left;
            display: block;
        }

        .form-control {
            box-shadow: none;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
        }

        .btn-primary, .btn-warning {
            font-size: 1rem;
            padding: 12px 20px;
            font-weight: 500;
            border-radius: 6px;
            transition: background 0.3s ease;
        }

        .btn-primary:hover {
           background: linear-gradient(145deg, #0056b3, #004494); /* Darker gradient on hover */
    transform: translateY(-2px);
}

        .alert {
            margin-top: 15px;
        }
/* Button */
.form-container form .btn-primary{
 background-color:#0d6efd;
}

/* Strong Tag */
.form-container p strong{
 color:#0d6efd !important;
}
/* Heading */
.form-container form h5{
 font-weight:600;
}

/* Paragraph */
.form-container form p{
 font-weight:600;
}
/* Strong Tag */
.form-container p strong{
 font-weight:600;
}
/* Button */
.form-container .d-grid a{
background: linear-gradient(145deg, #c71f1f, #e04d4d); /* Gradient background for a professional look */
  color: #ffffff; /* Text color */
  padding: 14px 28px;
  font-size: 14px; /* Font size */
  font-weight: 500; /* Font weight */
  border: none; /* Remove default border */
  border-radius: 5px; /* Slightly rounded corners */
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3); /* Subtle shadow for depth */
  transition: background 0.3s ease, transform 0.2s ease; /* Smooth transition for hover effects */
}

.form-container .d-grid a:hover {
  color: #ffffff !important; /* Text color */  
  background: linear-gradient(145deg, #e04d4d, #f76c6c); /* Darker gradient on hover */
  transform: translateY(-2px); /* Slight lift effect */
}



    </style>
</head>
<body>
    <div class="auth-container">
       <div class="form-container">
        <form action="<?=site_url("admin/activate-google-2fa")?>" method="POST">
            <h5>Secure Login with Two-Factor Authentication (2FA)</h5>
            <h6>
Please scan the QR code or manually enter the code below into the <a target="_blank" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2">Google Authenticator</a> app to set up two-factor authentication.</h6>
            <img class="rounded mx-auto d-block mb-2" style="height:250px;width:250px;" src="data:image/png;base64,<?=$encoded_qr_data?>" alt="Google Authenticator Setup QR Code">
            <p align="center" class="h6">Code : <strong class="text-success"><?=$GoogleTFA_admin->google2fa_secret ?></strong></p>
            <div class="error"></div>
            <div class="mb-3">
                <label class="form-label" for="2FA_Code">Please enter the 6-digit code generated by the Google Authenticator app :</label>
                <input type="hidden" id="secret_key" name="secret_key" value="<?=$GoogleTFA_admin->google2fa_secret?>">
                <input id="2FA_Code" type="number" class="form-control" name="2FA_Code" placeholder="Code" autocomplete="off">
            </div>
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary">
Activate Two-Step Verification</button>
                <a class="btn btn-warning" href="<?=site_url("admin")?>">Skip</a>
            </div>

        </form>
    </div>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(() => {
                alert("Code copied to clipboard");
            }).catch(err => {
                console.error("Could not copy text: ", err);
            });
        }

        $(document).ready(function() {
            $("form").submit(function(e) {
                e.preventDefault();
                var secret_key = $("#secret_key").val();
                var _2fa_code = $("#2FA_Code").val();
                var error = $(".error");
                $.ajax({
                    url: "<?=site_url("admin/activate-google-2fa")?>",
                    data: {secret_key: secret_key, 2FA_Code: _2fa_code},
                    type: "POST",
                    success: function(response) {
                        response = JSON.parse(response);
                        if (!response.success) {
                            error.html('<div class="alert alert-danger alert-dismissible fade show" role="alert"> <strong>'+response.message+'</strong><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
                        } else {
                            error.html('<div class="alert alert-success alert-dismissible fade show" role="alert"> <strong>'+response.message+'</strong><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>');
                            setTimeout(() => { window.location.href = "/admin"; }, 1500);
                        }
                    }
                });
            });
        });
    </script>
</body>
</html>
